<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

//Admin
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\ServiceCategoryController as AdminServiceCategoryController;
use App\Http\Controllers\Admin\ServiceController as AdminServiceController;
use App\Http\Controllers\Admin\QuestionController as AdminQuestionController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\ServiceTarrifController as AdminServiceTarrifController;
use App\Http\Controllers\Admin\ServiceFeatureController as AdminServiceFeatureController;
use App\Http\Controllers\Admin\HomeController as AdminHomeController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\ProtestController as AdminProtestController;
use App\Http\Controllers\Admin\ExpertController as AdminExpertController;


//User
use App\Http\Controllers\User\AuthController as UserAuthController;
use App\Http\Controllers\User\AddressController;
use App\Http\Controllers\User\OrderController as UserOrderController;
use App\Http\Controllers\User\ProfileController as UserProfileController;
use App\Http\Controllers\User\NotificationController as UserNotificationController;
use App\Http\Controllers\User\ProtestController as UserProtestController;
use App\Http\Controllers\User\ReportController as UserReportController;

//Public
use App\Http\Controllers\Home\ServicesController as PublicServicesController;
use App\Http\Controllers\Home\HomeController as PublicHomeController;
use App\Http\Controllers\UploadController;
use App\Http\Controllers\LocationController;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/admin/auth/login', [AdminAuthController::class, 'login']);
Route::get('/admin/auth/register', [AdminAuthController::class, 'register']);

Route::group(['prefix' => 'admin', 'middleware' => ['assign.guard:admins', 'jwt.auth']], function () {
    Route::get('/services/categories/main', [AdminServiceCategoryController::class, 'index']);
    Route::post('/services/categories/subcategory', [AdminServiceCategoryController::class, 'subCategories']);
    Route::get('/services/categories/details/{id}', [AdminServiceCategoryController::class, 'details']);
    Route::post('/services/categories/add', [AdminServiceCategoryController::class, 'create']);
    Route::post('/services/categories/update', [AdminServiceCategoryController::class, 'update']);
    Route::post('/services/categories/delete', [AdminServiceCategoryController::class, 'delete']);
    Route::post('/services/categories/change-order', [AdminServiceCategoryController::class, 'changeCategoryOrder']);
    Route::post('/services/categories/change-sub-category-order', [AdminServiceCategoryController::class, 'changeSubCategoryOrder']);


    Route::get('/services/all', [AdminServiceController::class, 'index']);
    Route::get('/services/details/{id}', [AdminServiceController::class, 'details']);
    Route::post('/services/add', [AdminServiceController::class, 'create']);
    Route::post('/services/update', [AdminServiceController::class, 'update']);
    Route::post('/services/delete', [AdminServiceController::class, 'delete']);
    Route::post('/services/change-status', [AdminServiceController::class, 'changeStatus']);
    Route::post('/services/change-order', [AdminServiceController::class, 'changeOrder']);
    Route::post('/services/total', [AdminServiceController::class, 'getTotal']);

    Route::post('/services/questions', [AdminQuestionController::class, 'index']);
    Route::get('/services/questions/details/{id}', [AdminQuestionController::class, 'details']);
    Route::post('/services/questions/add', [AdminQuestionController::class, 'create']);
    Route::post('/services/questions/update', [AdminQuestionController::class, 'update']);
    Route::post('/services/questions/delete', [AdminQuestionController::class, 'delete']);
    Route::post('/services/questions/change-order', [AdminQuestionController::class, 'changeOrder']);
    Route::post('/services/questions/change-next', [AdminQuestionController::class, 'setNextQuestion']);

    Route::post('/services/tarrif/get', [AdminServiceTarrifController::class, 'index']);
    Route::post('/services/tarrif/add', [AdminServiceTarrifController::class, 'create']);
    Route::post('/services/tarrif/update', [AdminServiceTarrifController::class, 'update']);
    Route::post('/services/tarrif/delete', [AdminServiceTarrifController::class, 'delete']);
    Route::post('/services/tarrif/manage-show', [AdminServiceTarrifController::class, 'manageShowTarrif']);

    Route::post('/services/feature/get', [AdminServiceFeatureController::class, 'index']);
    Route::post('/services/feature/add', [AdminServiceFeatureController::class, 'create']);
    Route::post('/services/feature/update', [AdminServiceFeatureController::class, 'update']);
    Route::post('/services/feature/delete', [AdminServiceFeatureController::class, 'delete']);



    Route::post('/orders/get', [AdminOrderController::class, 'index']);
    Route::get('/orders/details/{id}', [AdminOrderController::class, 'details']);
    Route::post('/orders/cancel', [AdminOrderController::class, 'cancelOrder']);
    Route::post('/orders/expert/set', [AdminOrderController::class, 'setExpert']);
    Route::post('/orders/confirm', [AdminOrderController::class, 'confirm']);

    Route::post('/home/slider/get', [AdminHomeController::class, 'slider']);
    Route::post('/home/slider/add', [AdminHomeController::class, 'addSlide']);
    Route::post('/home/slider/update', [AdminHomeController::class, 'updateSlide']);
    Route::post('/home/slider/delete', [AdminHomeController::class, 'deleteSlide']);
    Route::post('/home/banner/update', [AdminHomeController::class, 'editBanner']);
    Route::post('/home/banner/get', [AdminHomeController::class, 'getBanners']);


    Route::get('/users/get', [AdminUserController::class, 'index']);
    Route::get('/users/details/{id}', [AdminUserController::class, 'details']);
    Route::post('/users/update', [AdminUserController::class, 'update']);

    Route::post('/dashboard/statics', [AdminDashboardController::class, 'statics']);
    Route::post('/dashboard/chart/users', [AdminDashboardController::class, 'userChart']);
    Route::post('/dashboard/chart/orders', [AdminDashboardController::class, 'orderChart']);
    Route::post('/dashboard/top-services', [AdminDashboardController::class, 'topServices']);

    Route::get('/protests/get', [AdminProtestController::class, 'index']);
    Route::post('/protests/check', [AdminProtestController::class, 'check']);

    Route::get('/experts/get', [AdminExpertController::class, 'index']);
    Route::get('/experts/details/{id}', [AdminExpertController::class, 'details']);
    Route::post('/experts/create', [AdminExpertController::class, 'create']);
    Route::post('/experts/update', [AdminExpertController::class, 'update']);
    Route::post('/experts/delete', [AdminExpertController::class, 'delete']);
});


Route::post('/user/auth/request-code', [UserAuthController::class, 'requestCode']);
Route::post('/user/auth/validate-code', [UserAuthController::class, 'validateUser']);
Route::post('/user/auth/register', [UserAuthController::class, 'register']);

Route::group(['prefix' => 'user', 'middleware' => ['assign.guard:users', 'jwt.auth']], function () {

    Route::post('/auth/set-token', [UserAuthController::class, 'setToken']);
    Route::post('/auth/logout', [UserAuthController::class, 'logout']);

    Route::get('/addresses/get', [AddressController::class, 'index']);
    Route::post('/addresses/add', [AddressController::class, 'create']);
    Route::post('/addresses/update', [AddressController::class, 'update']);
    Route::post('/addresses/delete', [AddressController::class, 'delete']);

    Route::get('/orders/get', [UserOrderController::class, 'index']);
    Route::post('/orders/add', [UserOrderController::class, 'create']);
    Route::post('/orders/details', [UserOrderController::class, 'details']);
    Route::post('/orders/cancel', [UserOrderController::class, 'cancelOrder']);
    Route::post('/orders/proposals', [UserOrderController::class, 'proposals']);
    Route::post('/orders/get-factor', [UserOrderController::class, 'getFactor']);
    Route::post('/orders/manage-proposal', [UserOrderController::class, 'manageProposal']);
    Route::post('/orders/manage-result', [UserOrderController::class, 'manageOrderResult']);
    Route::post('/orders/validate-discount', [UserOrderController::class, 'validateDiscount']);

    Route::post('/profile/update', [UserProfileController::class, 'update']);
    Route::post('/profile/delete', [UserProfileController::class, 'deleteProfile']);



    Route::get('/notifications/get', [UserNotificationController::class, 'index']);


    Route::post('/protest/create', [UserProtestController::class, 'create']);


    Route::post('/report/create', [UserReportController::class, 'create']);
});



Route::get('/services/categories', [PublicServicesController::class, 'Categories']);
Route::get('/services/category-with-services', [PublicServicesController::class, 'ServicesWithCategory']);
Route::get('/services/category-details/{id}', [PublicServicesController::class, 'CategoryDetails']);
Route::get('/services/home-categories', [PublicServicesController::class, 'homeCategory']);
Route::post('/services/services', [PublicServicesController::class, 'Services']);
Route::post('/services/details', [PublicServicesController::class, 'ServiceDetails']);
Route::post('/services/details-with-question', [PublicServicesController::class, 'ServiceDetailsWithQuestions']);
Route::post('/services/search', [PublicServicesController::class, 'Search']);
Route::post('/services/questions', [PublicServicesController::class, 'ServiceQuestions']);
Route::get('/services/most-used', [PublicServicesController::class, 'mostUsed']);

Route::get('/home/slider', [PublicHomeController::class, 'slider']);
Route::get('/home/banners', [PublicHomeController::class, 'banners']);
Route::post('/home/banner', [PublicHomeController::class, 'getBanner']);

Route::post('/location/states', [LocationController::class, 'getStates']);


//Common
Route::post('/upload/avatar', [UploadController::class, 'avatar']);
Route::put('/upload/avatar', [UploadController::class, 'avatar']);
Route::post('/upload/video', [UploadController::class, 'video']);
Route::post('blogEditorImages', [UploadController::class, 'blogEditorImages']);

//AppVersion
Route::post('/user/version', [UserAuthController::class, 'checkVersion']);

Route::get('/clear-cache', function () {

    $exitCode = Artisan::call('optimize');
    $exitCode = Artisan::call('migrate');
    $exitCode1 = Artisan::call('config:cache');
    return 'DONE'; //Return anything
});

Route::get('/fix-categories', [AdminServiceCategoryController::class, 'fixSorting']);
Route::get('/fix-questions', [AdminQuestionController::class, 'fixSorting']);
Route::get('/fix-services', [AdminServiceController::class, 'fixSorting']);
Route::get('/add-questions', [AdminServiceController::class, 'addQuestions']);
