<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_results', function (Blueprint $table) {
            $table->enum('factor_type', ['wages_extra', 'wages'])->default('wages_extra')->after('total');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_results', function (Blueprint $table) {
            $table->dropColumn('factor_type');
        });
    }
};
