<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('protests', function (Blueprint $table) {
            $table->id();
            $table->enum('user_type',['user','expert'])->default('user');
            $table->unsignedBigInteger('user_id');
            $table->string('type');
            $table->string('description');
            $table->string('extra')->nullable();
            $table->string('attachment')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('protests');
    }
};
