<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('question_values', function (Blueprint $table) {
            $table->unsignedBigInteger('next_question')->nullable();
            $table->foreign('next_question')->references('id')->on('questions')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('question_values', function (Blueprint $table) {
            $table->dropColumn('next_question');
        });
    }
};
