<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->enum('sender_type', ['admin', 'expert', 'user'])->default('admin');
            $table->unsignedBigInteger('sender_id')->nullable();
            $table->unsignedBigInteger('receiver_id');
            $table->enum('receiver_type', ['expert', 'user'])->default('user');
            $table->string('content');
            $table->unsignedBigInteger('order_id')->nullable();
            $table->unsignedBigInteger('extra_id')->nullable();
            $table->string('type')->default('send-proposal');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
