<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_results', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->double('wages', 16, 0, true)->default(0);
            $table->double('extra', 16, 0, true)->default(0);
            $table->double('fee')->default(0);
            $table->double('total', 16, 0, true)->default(0);
            $table->mediumText('description')->nullable();
            $table->mediumText('reason')->nullable();
            $table->tinyInteger('rating')->default(0);
            $table->enum('status', ['expert-done', 'user-confirmed', 'user-rejected'])->default('expert-done');
            $table->timestamps();
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_results');
    }
};
