<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('service_id');
            $table->string('date', 15)->nullable();
            $table->string('time', 15)->nullable();
            $table->string('address', 125)->nullable();
            $table->string('phone')->nullable();
            $table->string('lat', 16)->nullable();
            $table->string('lang', 16)->nullable();
            $table->enum('status', ['searching-expert', 'doing', 'canceled', 'done', 'user-confirm', 'expert-violation'])->default('searching-expert');
            $table->string('reason')->nullable();
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('CASCADE');
            $table->foreign('service_id')->references('id')->on('services')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};
