<?php

namespace App\Services\NotificationService;

use App\Models\DeviceToken;
use App\Models\Notification;
use App\Models\Order;
use App\Models\Service;
use App\Models\User;
use App\Services\SmsService\SmsService;
use Illuminate\Support\Facades\Http;

class NotificationService
{
    public static function sendNotification($sender_type, $sender_id, $receiver_id, $receiver_type, $order_id, $extra_id, $type)
    {

        if ($sender_type == "user") {
            $sender = User::where('id', $sender_id)->first();
        }
        switch ($type) {
            case "new-order":
                $order = Order::where('id', $order_id)->first();
                $serviceData = Service::where('id', $order->service_id)->first();
                $content = "کار جدید یافت شد! هرچه سریعتر اعلام آمادگی کن." . $sender->first_name . " " . $sender->last_name . " در خدمت (" . $serviceData->title . ") به دنبال متخصص میگردد.";
                break;
            case "accept-proposal":
                $order = Order::where('id', $order_id)->first();
                $serviceData = Service::where('id', $order->service_id)->first();
                $content = "تایید درخواست انجام خدمت (" . $serviceData->title . ") توسط " . $sender->first_name . " " . $sender->last_name;
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "تایید درخواست انجام هدمت",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);

                $content = "رد درخواست انجام خدمت (" . $serviceData->title . ") توسط " . $sender->first_name . " " . $sender->last_name;

                break;
            case "reject-proposal":
                $order = Order::where('id', $order_id)->first();
                $serviceData = Service::where('id', $order->service_id)->first();
                $content = "رد درخواست انجام خدمت (" . $serviceData->title . ") توسط " . $sender->first_name . " " . $sender->last_name;
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "رد درخواست انجام خدمت",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
            case "reject-result":
                $content = "رد صورت حساب (" . $order_id . ") توسط " . $sender->first_name . " " . $sender->last_name;
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "رد صورتحساب",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
            case "accept-result":
                $content = "تایید صورت حساب (" . $order_id . ") توسط " . $sender->first_name . " " . $sender->last_name;
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "تایید صورتحساب",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
            case "send-proposal":
                $order = Order::where('id', $order_id)->first();
                $serviceData = Service::where('id', $order->service_id)->first();
                $content = $sender->first_name . " " . $sender->last_name . " آمادگی خود را برای انجام خدمت (" . $serviceData->title . ") اعلام کرده و منتظر تایید یا رد شما میباشد";
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "اعلام آمادگی متخصص",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
            case "set-result":
                $content = "صورت حساب (" . $order_id . ") توسط متخصص تکمیل گردیده و در انتظار تایید یا رد شما می باشد. لطفا آن را بررسی نمایید.";
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "صدور صورتحساب",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
            case "assign-expert":
                $content = "متخصص جدید به سفارش شما تخصیص یافت";
                NotificationService::processNotif(
                    $sender_type,
                    $sender_id,
                    $receiver_id,
                    $receiver_type,
                    "متخصص انتخاب شد",
                    $content,
                    $order_id,
                    $extra_id,
                    $type
                );
                SmsService::sendNotif($receiver_id, $receiver_type, $content);
                break;
        }
        return "done";
    }

    public static function processNotif($sender_type, $sender_id, $expert_id, $receiver_type, $title, $content, $order_id, $extra_id, $type)
    {
        Notification::create([
            'sender_type' => $sender_type,
            'sender_id' => $sender_id,
            'receiver_id' => $expert_id,
            'receiver_type' => $receiver_type,
            'title' => $title,
            'content' =>  $content,
            'order_id' => $order_id,
            'extra_id' => $extra_id,
            'type' => $type
        ]);
        if ($receiver_type == "expert") {
            return NotificationService::sendExpertNotification($expert_id, $sender_id, $sender_type, $content, $order_id, $extra_id, $type);
        } else {
            return NotificationService::sendUserNotification($expert_id, $sender_id, $sender_type, $content, $order_id, $extra_id, $type);
        }
    }
    public static function sendExpertNotification($receiver_id, $sender_id, $sender_type, $content, $order_id, $extra_id, $type)
    {
        $tokens = DeviceToken::where('user_id', $receiver_id)->where('user_type', "expert")->where('active', 1)->pluck('token')->toArray();
        if (count($tokens) < 1) {
            return "";
        }

        $sender = "";
        if ($sender_type == "user") {
            $sender = json_encode(User::where('id', $sender_id)->select(['id', 'first_name', 'last_name', 'avatar'])->first());
        }

        $response = Http::post('https://eitook-fcm.softwares-land.ir/firebase/achare_expert/notification', [
            'tokens' => json_encode($tokens),
            'customData' => [
                'sender_type' => $sender_type,
                'sender' => $sender,
                'order_id' => $order_id . "",
                'extra_id' => $extra_id . "",
                'content' => $content,
                'type' => $type . ""
            ],
        ]);
        return $response;
    }

    public static function sendUserNotification($receiver_id, $sender_id, $sender_type, $content, $order_id, $extra_id, $type)
    {
        $tokens = DeviceToken::where('user_id', $receiver_id)->where('user_type', "user")->where('active', 1)->pluck('token')->toArray();
        if (count($tokens) < 1) {
            return "";
        }

        $sender = "";

        $response = Http::post('https://eitook-fcm.softwares-land.ir/firebase/achare/notification', [
            'tokens' => json_encode($tokens),
            'customData' => [
                'sender_type' => $sender_type,
                'sender' => $sender,
                'order_id' => $order_id . "",
                'extra_id' => $extra_id . "",
                'content' => $content,
                'type' => $type . ""
            ],
        ]);
        return $response;
    }
}
