<?php

namespace App\Services\MobileTokenService;

use App\Models\MobileToken;
use Carbon\Carbon;

class MobileTokenService
{
    public static function generateToken($mobile)
    {
        MobileToken::where('mobile', $mobile)->delete();
        // if ($mobile == "09123456789" || $mobile == "9123456789") {
        //     $six_digit_random_number = 12345;
        // } else {
        //     $six_digit_random_number = random_int(10000, 99999);
        // }

        $six_digit_random_number=12345;
        MobileToken::create([
            'mobile' => $mobile,
            'code' => $six_digit_random_number
        ]);
        return $six_digit_random_number;
    }

    public static function verifyToken($mobile, $code)
    {
        $token = MobileToken::where('mobile', $mobile)
            ->where('created_at', ">", Carbon::now()->subMinutes(2))
            ->where('code', $code)->first();
        if (!$token) {
            return false;
        }
        return true;
    }
}
