<?php

namespace App\Services\DeviceTokenService;

use App\Models\DeviceToken;

class DeviceTokenService
{
    public static function setToken($user_id, $user_type, $token)
    {
        DeviceToken::where('token', $token)->where('user_type', $user_type)->where('user_id', '!=', $user_id)->update(['active' => 0]);

        $check = DeviceToken::where('token', $token)
            ->where('user_type', $user_type)
            ->where('user_id', $user_id)
            ->where('active', 1)->first();
        if (!$check) {
            DeviceToken::create([
                'user_id' => $user_id,
                'user_type' => $user_type,
                'token' => $token
            ]);
        }
    }

    public static function deactiveToken($user_id, $user_type, $token)
    {
        DeviceToken::where('token', $token)->where('user_type', $user_type)->where('user_id', $user_id)->update(['active' => 0]);
    }
}
