<?php


namespace App\Services\Bank;


use App\Exceptions\BankAccount\BankAccountIsBlockedException;
use App\Models\WorkOffice;
use Bavix\Wallet\Interfaces\Wallet;

class Bank
{

    public static function wallet(Wallet $owner, $wallet_name): Wallet
    {
        $slug = "$wallet_name-slug";
        if (!$owner->hasWallet($slug))
            $owner->createWallet([
                'name' => $wallet_name,
                'slug' => $slug
            ]);

        return $owner->getWallet($slug);
    }

    public static function deposit(Wallet $wallet, $amount, $meta = null)
    {
        if (is_string($meta))
            $meta = ['description' => $meta];
        $tr = $wallet->deposit($amount, $meta);
        $tr->save();
        return $tr;
    }

    public static function withdraw(Wallet $wallet, $amount, $meta = null)
    {
        if (is_string($meta))
            $meta = ['description' => $meta];

        $tr = $wallet->withdraw($amount, $meta);
        $tr->save();
        return $tr;
    }

    public static function forceWithdraw(Wallet $wallet, $amount, $meta = null)
    {
        if (is_string($meta))
            $meta = ['description' => $meta];
        $tr =  $wallet->forceWithdraw($amount, $meta);
        $tr->save();
        return $tr;
    }

    public static function checkout(Wallet $wallet)
    {
        $amount = self::getBalance($wallet);
        if (!$wallet->holder->canWithdraw($amount))
            throw new BankAccountIsBlockedException;

        $transaction = $wallet->forceWithdraw($amount, ['description' => trans('responses.ebank-checkout', [], request()->query("locale", "fa"))]);
        $transaction->update(['category' => CHECKOUT_TRANSACTION]);

        return $transaction;
    }

    public static function newCheckout(Wallet $wallet, $amount)
    {
        if (!$wallet->holder->canWithdraw($amount))
            throw new BankAccountIsBlockedException;

        $transaction = $wallet->forceWithdraw($amount, ['description' => trans('responses.ebank-checkout', [], request()->query("locale", "fa"))]);
        $transaction->update(['category' => CHECKOUT_TRANSACTION]);

        return $transaction;
    }


    public static function transfer(Wallet $from_wallet, Wallet $to_wallet, $amount, $meta = null)
    {

        if (is_string($meta))
            $meta = ['description' => $meta];
        if (!$from_wallet->holder->canWithdraw($amount))
            throw new BankAccountIsBlockedException;
        return $from_wallet->transfer($to_wallet, $amount, $meta);
    }

    public static function getBalance(Wallet $wallet)
    {
        $wallet->refreshBalance();
        return $wallet->balance;
    }

    public static function refresh(Wallet $wallet)
    {
        $wallet->refreshBalance();
    }
}
