<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'sub_title',
        'image',
        'description',
        'category_id',
        'active',
        'fee_percent',
        'updated_at',
        'sort_order',
        'assign_policy',
        'price_type',
        'price',
        'price_description',
        'rule',
        'start_hour',
        'end_hour',
        'delay',
        'factor_type',
        'show_tarrif'
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function questions()
    {
        return $this->hasMany(Question::class, 'service_id', 'id');
    }

    public function tarrifs()
    {
        return $this->hasMany(ServiceTarrif::class, 'service_id', 'id');
    }

    public function features()
    {
        return $this->hasMany(ServiceFeature::class, 'service_id', 'id')->orderByDesc('status');
    }

}
