<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderResult extends Model
{
    use HasFactory;
    protected $fillable = [
        'order_id',
        'wages',
        'extra',
        'fee',
        'total',
        'description',
        'reason',
        'rating',
        'status',
        'factor_type',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id', 'id');
    }
}
