<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'service_id',
        'date',
        'time',
        'address',
        'phone',
        'lat',
        'lang',
        'status',
        'canceled_at',
        'set_expert_at',
        'set_result_at',
        'completed_at',
        'price',
        'discount_id',
        'expert_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }


    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }

    public function expert()
    {
        return $this->belongsTo(Expert::class, 'expert_id', 'id');
    }


    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    public function discountCode()
    {
        return $this->belongsTo(Discount::class, 'discount_id', 'id');
    }
}
