<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $fillable=['name','deleted','image','parent','active','sort_order','banner'];

    public function items(){
        return $this->hasMany(Category::class, 'parent', 'id')->where('active',1)->where('deleted',0);
    }

    public function services(){
        return $this->hasMany(Service::class, 'category_id', 'id')->where('active',1)->orderBy('sort_order');
    }

    public function allServices(){
        return $this->hasMany(Service::class, 'category_id', 'id')->where('active','!=',0)->orderBy('sort_order');
    }

    public function parentData(){
        return $this->belongsTo(Category::class, 'parent', 'id');
    }

}
