<?php

namespace App\Http\Resources\User;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Facades\URL;

class UserCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {

            $avatar="";
            if($item->avatar){
                $avatar= URL::to('/').'/'.$item->avatar;
            }
            return $this->filterFields([
                'id' => $item->id,
                'first_name' => $item->first_name,
                'last_name' => $item->last_name,
                'mobile' => $item->mobile,
                'birth_date' => $item->birth_date,
                'gender' => $item->gender,
                'email' => $item->email,
                'avatar' => $avatar,
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
