<?php

namespace App\Http\Resources\ServiceWithQuestions;

use App\Helpers\ResponseData;
use App\Http\Resources\Question\QuestionResource;
use App\Models\AdminRole;
use App\Models\Question;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class ServiceWithQuestionsResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new ServiceWithQuestionsCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $questions = $this->questions()->orderBy('sort_order')->get();
        // $questions->push(new Question([
        //     'id' => -1,
        //     'type' => 1,
        //     'title' => 'چه زمانی به این سرویس نیاز دارید؟',
        //     'short_title' => 'تاریخ و زمان',
        //     'next_question' => null,
        //     'allow_multiple' => false,
        // ]));
        // $questions->push(new Question([
        //     'id' => -1,
        //     'type' => 5,
        //     'title' => 'آدرس را انتخاب کنید:',
        //     'short_title' => 'آدرس',
        //     'next_question' => null,
        //     'allow_multiple' => false,
        // ]));
        return $this->filterFields([
            'id' => $this->id,
            'title' => $this->title,
            'sub_title' => $this->sub_title,
            'category' => $this->category,
            'image' => $this->image,
            'description' => $this->description,
            'assign_policy' => $this->assign_policy,
            'questions' => QuestionResource::collection($questions),
            'fee_percent' => $this->fee_percent,
            'price_type' => $this->price_type,
            'price' => $this->price,
            'price_description' => $this->price_description,
            'features' => $this->features,
            'rule' => $this->rule,
            'start_hour' => $this->start_hour,
            'end_hour' => $this->end_hour,
            'delay' => $this->delay,
            'active' => $this->active,
            'factor_type'=>$this->factor_type,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
