<?php

namespace App\Http\Resources\ServiceWithQuestions;

use App\Helpers\ResponseData;
use App\Http\Resources\Question\QuestionResource;
use App\Models\Question;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ServiceWithQuestionsCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            $questions = $item->questions;
            // $questions->push(new Question([
            //     'id' => -1,
            //     'type' => 1,
            //     'title' => 'چه زمانی به این سرویس نیاز دارید؟',
            //     'short_title' => 'تاریخ و زمان',
            //     'next_question' => null,
            //     'allow_multiple' => false,
            // ]));
            // $questions->push(new Question([
            //     'id' => -1,
            //     'type' => 5,
            //     'title' => 'آدرس را انتخاب کنید:',
            //     'short_title' => 'آدرس',
            //     'next_question' => null,
            //     'allow_multiple' => false,
            // ]));
            return $this->filterFields([
                'id' => $item->id,
                'title' => $item->title,
                'sub_title' => $item->sub_title,
                'image' => $item->image,
                'catrgory' => $item->category,
                'description' => $item->description,
                'assign_policy' => $item->assign_policy,
                'questions' => QuestionResource::collection($questions),
                'fee_percent' => $item->fee_percent,
                'price_type' => $item->price_type,
                'price' => $item->price,
                'price_description' => $item->price_description,
                'features' => $item->features,
                'rule' => $item->rule,
                'start_hour' => $item->start_hour,
                'end_hour' => $item->end_hour,
                'delay' => $item->delay,
                'active' => $item->active,
                'factor_type' => $item->factor_type,
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
