<?php

namespace App\Http\Resources\ServiceSimple;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceSimpleResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new ServiceSimpleCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        return $this->filterFields([
            'id' => $this->id,
            'title' => $this->title,
            'sub_title' => $this->sub_title,
            'category' => $this->category,
            'image' => $this->image,
            'description' => $this->description,
            'assign_policy' => $this->assign_policy,
            'active' => $this->active,
            'fee_percent' => $this->fee_percent,
            'price_type' => $this->price_type,
            'price_description' => $this->price_description,
            'price' => $this->price,
            'rule' => $this->rule,
            'start_hour' => $this->start_hour,
            'end_hour' => $this->end_hour,
            'delay' => $this->delay,
            'factor_type' => $this->factor_type,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
