<?php

namespace App\Http\Resources\ServiceSimple;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ServiceSimpleCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            return $this->filterFields([
                'id' => $item->id,
                'title' => $item->title,
                'sub_title' => $item->sub_title,
                'image' => $item->image,
                'catrgory' => $item->category,
                'description' => $item->description,
                'assign_policy' => $item->assign_policy,
                'active' => $item->active,
                'fee_percent' => $item->fee_percent,
                'price_type' => $item->price_type,
                'price_description' => $item->price_description,
                'price' => $item->price,
                'rule' => $item->rule,
                'start_hour' => $item->start_hour,
                'end_hour' => $item->end_hour,
                'delay' => $item->delay,
                'factor_type' => $item->factor_type,
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
