<?php

namespace App\Http\Resources\Service;

use App\Helpers\ResponseData;
use App\Models\Order;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new ServiceCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $allOrders = Order::where('service_id', $this->id)->count();;

        return $this->filterFields([
            'id' => $this->id,
            'title' => $this->title,
            'sub_title' => $this->sub_title,
            'category' => $this->category,
            'image' => $this->image,
            'description' => $this->description,
            'assign_policy' => $this->assign_policy,
            'active' => $this->active,
            'tarrifs' => $this->show_tarrif == 1 ? $this->tarrifs : [],
            'features' => $this->features,
            'fee_percent' => $this->fee_percent,
            'price_type' => $this->price_type,
            'all_orders' => $allOrders,
            'price_description' => $this->price_description,
            'price' => $this->price,
            'rule' => $this->rule,
            'start_hour' => $this->start_hour,
            'end_hour' => $this->end_hour,
            'delay' => $this->delay,
            'factor_type' => $this->factor_type,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
