<?php

namespace App\Http\Resources\Question;

use App\Helpers\ResponseData;
use App\Models\AdminRole;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class QuestionResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new QuestionCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->filterFields([
            'id' => $this->id,
            'title' => $this->title,
            'short_title' => $this->short_title,
            'extra' => $this->extra,
            'type'=> $this->type,
            'allow_multiple' => $this->allow_multiple,
            'values'=>$this->values,
            'sort_order'=> $this->sort_order,
            'is_required'=> $this->is_required,
            'next_question'=> $this->next_question,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
