<?php

namespace App\Http\Resources\Question;

use App\Helpers\ResponseData;
use Illuminate\Http\Resources\Json\ResourceCollection;

class QuestionCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            return $this->filterFields([
                'id' => $item->id,
                'title' => $item->title,
                'short_title' => $item->short_title,
                'extra' => $item->extra,
                'type' => $item->type,
                'allow_multiple' => $item->allow_multiple,
                'values' => $item->values,
                'sort_order'=> $item->sort_order,
                'is_required'=> $item->is_required,
                'next_question'=> $item->next_question,
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
