<?php

namespace App\Http\Resources\Protest;

use App\Helpers\ResponseData;
use App\Http\Resources\User\UserResource;
use App\Models\Expert;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;

class ProtestResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new ProtestCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $user = null;
        $user = UserResource::make(User::where('id', $this->user_id)->first());
        return $this->filterFields([
            'id' => $this->id,
            'user_type' => $this->user_type,
            'user' =>  $user,
            'type' => $this->type,
            'description' => $this->description,
            'extra' => $this->extra,
            'attachment' => $this->attachment,
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran'))
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
