<?php

namespace App\Http\Resources\Protest;

use App\Helpers\ResponseData;
use App\Http\Resources\User\UserResource;
use App\Models\Expert;
use App\Models\User;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Facades\URL;

class ProtestCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            $user = null;
            $user = UserResource::make(User::where('id', $item->user_id)->first());
            return $this->filterFields([
                'id' => $item->id,
                'user_type' => $item->user_type,
                'user' =>  $user,
                'type' => $item->type,
                'description' => $item->description,
                'extra' => $item->extra,
                'attachment' => $item->attachment,
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
