<?php

namespace App\Http\Resources\OrderResult;

use App\Helpers\ResponseData;
use App\Http\Resources\Order\OrderResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class OrderResultCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            return $this->filterFields([
                'id' => $item->id,
                'wages' => $item->wages,
                'extra' => $item->extra,
                'fee' => $item->fee,
                'total' => $item->total,
                'description' => $item->description,
                'reason' => $item->reason,
                'rating' => $item->rating,
                'status' => $item->status,
                'order_id' => $item->order_id,
                'factor_type' => $item->factor_type,
                'order' => new OrderResource($item->order),
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
