<?php

namespace App\Http\Resources\Order;

use App\Helpers\ResponseData;
use App\Http\Resources\ServiceSimple\ServiceSimpleResource;
use App\Http\Resources\User\UserResource;
use App\Models\AdminRole;
use App\Models\OrderQuestionAnswers;
use App\Models\Question;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class OrderResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new OrderCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $orderQuestion = OrderQuestionAnswers::where('order_id', $this->id)->pluck('question_id')->toArray();
        $questions = Question::whereIn('id', $orderQuestion)->get();
        for ($i = 0; $i < count($questions); $i++) {
            $questions[$i]->answers = OrderQuestionAnswers::where('order_id', $this->id)
                ->where('question_id', $questions[$i]->id)
                ->get();
        }
        return $this->filterFields([
            'id' => $this->id,
            'service' => new ServiceSimpleResource($this->service),
            'questions' => $questions,
            'expert'=> $this->expert,
            'user' => new UserResource($this->user),
            'date' => $this->date,
            'time' => $this->time,
            'address' => $this->address,
            'phone' => $this->phone,
            'lat' => $this->lat,
            'lang' => $this->lang,
            'status' => $this->status,
            'price' => $this->price,
            'discount_code' => $this->discountCode,
            'proposals' => $this->proposals,
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran')),
            'canceled_at' => $this->canceled_at ? date(verta($this->canceled_at)->timezone('Asia/Tehran')) : null,
            'set_expert_at' => $this->set_expert_at ? date(verta($this->set_expert_at)->timezone('Asia/Tehran')) : null,
            'set_result_at' => $this->set_result_at ? date(verta($this->set_result_at)->timezone('Asia/Tehran')) : null,
            'completed_at' => $this->completed_at ? date(verta($this->completed_at)->timezone('Asia/Tehran')) : null,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
