<?php

namespace App\Http\Resources\Notification;

use App\Helpers\ResponseData;
use App\Http\Resources\Order\OrderResource;
use App\Http\Resources\User\UserResource;
use App\Models\Expert;
use App\Models\User;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new NotificationCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $sender = null;
        if ($this->receiver_type == "user") {
            $sender = new UserResource(User::where('id', $this->sender_id)->first());
        }
        return $this->filterFields([
            'id' => $this->id,
            'sender' => $sender,
            'sender_type' => $this->sender_type,
            'title' => $this->title,
            'content' => $this->content,
            'order_id' => $this->order_id,
            'type' => $this->type,
            'extra_id' => $this->extra_id,
            'seen' => $this->seen,
            'order' => new OrderResource($this->order),
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran'))
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
