<?php

namespace App\Http\Resources\Notification;

use App\Helpers\ResponseData;
use App\Http\Resources\Order\OrderResource;
use App\Http\Resources\User\UserResource;
use App\Models\Expert;
use App\Models\User;
use Illuminate\Http\Resources\Json\ResourceCollection;
use Illuminate\Support\Facades\URL;

class NotificationCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            $sender = null;
            if ($item->sender_type == "user") {
                $sender = new UserResource(User::where('id', $item->sender_id)->first());
            }
            return $this->filterFields([
                'id' => $item->id,
                'sender' => $sender,
                'sender_type' => $item->sender_type,
                'title' => $item->title,
                'content' => $item->content,
                'order_id' => $item->order_id,
                'type' => $item->type,
                'extra_id' => $item->extra_id,
                'seen' => $item->seen,
                'order' => new OrderResource($item->order),
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
