<?php

namespace App\Http\Resources\CategoryWithLastrServices;

use App\Helpers\ResponseData;
use App\Models\AdminRole;
use App\Models\Service;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class CategoryWithLastrServicesResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new CategoryWithLastrServicesCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $services = Service::join('categories', 'services.category_id', '=', 'categories.id')
            ->where('categories.parent', $this->id)
            ->where('services.active', 1)
            ->limit(4)->get('services.*');
        return $this->filterFields([
            'id' => $this->id,
            'name' => $this->name,
            'image' => $this->image,
            'banner' => $this->banner,
            'active' => $this->active,
            'services' => $services,
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran'))
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
