<?php

namespace App\Http\Resources\CategoryWithLastrServices;

use App\Helpers\ResponseData;
use App\Models\Service;
use Illuminate\Http\Resources\Json\ResourceCollection;

class CategoryWithLastrServicesCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            $services = Service::join('categories', 'services.category_id', '=', 'categories.id')
            ->where('categories.parent', $item->id)
            ->where('services.active', 1)
            ->limit(4)->get('services.*');
            return $this->filterFields([
                'id' => $item->id,
                'name' => $item->name,
                'image' => $item->image,
                'active'=> $item->active,
                'banner'=> $item->banner,
                'services' => $services,
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
