<?php

namespace App\Http\Resources\AdminService;

use App\Helpers\ResponseData;
use App\Http\Resources\CategoryWithParent\CategoryWithParentResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class AdminServiceResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new AdminServiceCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->filterFields([
            'id' => $this->id,
            'title' => $this->title,
            'sub_title' => $this->sub_title,
            'image' => $this->image,
            'category' => new CategoryWithParentResource($this->category),
            'category_id' => $this->category_id,
            'description' => $this->description,
            'fee_percent' => $this->fee_percent,
            'sort_order' => $this->sort_order,
            'active' => $this->active,
            'questions' => $this->questions,
            'assign_policy' => $this->assign_policy,
            'price_type' => $this->price_type,
            'price' => $this->price,
            'rule' => $this->rule,
            'start_hour' => $this->start_hour,
            'end_hour' => $this->end_hour,
            'delay' => $this->delay,
            'factor_type' => $this->factor_type,
            'price_description' => $this->price_description,
            'created_at' => date(verta($this->created_at)->timezone('Asia/Tehran')),
            'updated_at' => date(verta($this->updated_at)->timezone('Asia/Tehran'))
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
