<?php

namespace App\Http\Resources\AdminService;

use App\Helpers\ResponseData;
use App\Http\Resources\CategoryWithParent\CategoryWithParentResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class AdminServiceCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            return $this->filterFields([
                'id' => $item->id,
                'title' => $item->title,
                'sub_title' => $item->sub_title,
                'image' => $item->image,
                'category' => new CategoryWithParentResource($item->category),
                'category_id' => $item->category_id,
                'description' => $item->description,
                'fee_percent' => $item->fee_percent,
                'sort_order' => $item->sort_order,
                'active' => $item->active,
                'questions' => $item->questions,
                'assign_policy' => $item->assign_policy,
                'price_type' => $item->price_type,
                'price' => $item->price,
                'price_description' => $item->price_description,
                'rule' => $item->rule,
                'start_hour' => $item->start_hour,
                'end_hour' => $item->end_hour,
                'delay' => $item->delay,
                'factor_type' => $item->factor_type,
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran')),
                'updated_at' => date(verta($item->updated_at)->timezone('Asia/Tehran'))
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
