<?php

namespace App\Http\Resources\AdminOrder;

use App\Helpers\ResponseData;
use App\Http\Resources\ExpertBase\ExpertBaseResource;
use App\Http\Resources\Service\ServiceResource;
use App\Http\Resources\ServiceSimple\ServiceSimpleResource;
use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\ResourceCollection;

class AdminOrderCollection extends ResourceCollection
{
    protected $withoutFields = [];


    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Support\Collection
     */
    public function toArray($request)
    {

        return $this->collection->map(function ($item) {
            $questions = [];
            return $this->filterFields([
                'id' => $item->id,
                'service' => new ServiceSimpleResource($item->service,),
                'expert' => $item->expert,
                // 'questions' => $questions,
                'user' => new UserResource($item->user),
                'date' => $item->date,
                'time' => $item->time,
                'address' => $item->address,
                'phone' => $item->phone,
                'lat' => $item->lat,
                'lang' => $item->lang,
                'status' => $item->status,
                'price'=> $item->price,
                'discount_code'=> $item->discountCode,
                // 'proposals' => $item->proposals,
                'created_at' => date(verta($item->created_at)->timezone('Asia/Tehran')),
                'canceled_at' => $item->canceled_at ? date(verta($item->canceled_at)->timezone('Asia/Tehran')) : null,
                'set_expert_at' => $item->set_expert_at ? date(verta($item->set_expert_at)->timezone('Asia/Tehran')) : null,
                'set_result_at' => $item->set_result_at ? date(verta($item->set_result_at)->timezone('Asia/Tehran')) : null,
                'completed_at' => $item->completed_at ? date(verta($item->completed_at)->timezone('Asia/Tehran')) : null,
            ]);
        });
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
