<?php

namespace App\Http\Resources\Address;

use App\Helpers\ResponseData;
use App\Models\AdminRole;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class AddressResource extends JsonResource
{
    //
    protected $withoutFields = [];

    public static function collection($resource)
    {
        return tap(new AddressCollection($resource), function ($collection) {
            $collection->collects = __CLASS__;
        });
    }

    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return $this->filterFields([
            'id' => $this->id,
            'address' => $this->address,
            'title' => $this->title,
            'plate' => $this->plate,
            'unit' => $this->unit,
            'phone' => $this->phone,
            'lat' => $this->lat,
            'lang' => $this->lang,
        ]);
    }

    public function with($request)
    {
        return ResponseData::status();
    }

    /**
     * Set the keys that are supposed to be filtered out.
     *
     * @param array $fields
     * @return $this
     */
    public function hide(array $fields)
    {
        $this->withoutFields = $fields;

        return $this;
    }

    /**
     * Remove the filtered keys.
     *
     * @param $array
     * @return array
     */
    protected function filterFields($array)
    {
        return collect($array)->forget($this->withoutFields)->toArray();
    }
}
