<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RegisterUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'mobile' => 'required|string|max:15|unique:users',
            'email' => 'sometimes|nullable|unique:users',
            'birth_date' => 'sometimes|nullable',
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'avatar' => 'sometimes|nullable',
            'fcm_token' => 'sometimes|nullable',
        ];
    }

    public function messages()
    {
        return [
            'mobile.required' => ' شماره موبایل اجباری است',
            'email.unique' => 'ایمیل وارد شده متعلق به حساب کاربری دیگری میباشد',
            'mobile.unique' => 'شماره موبایل وارد شده متعلق به حساب کاربری دیگری میباشد',
            'first_name.required' => 'نام اجباری است',
            'last_name.required' => 'نام خانوادگی اجباری است',
        ];
    }
}
