<?php

namespace App\Http\Controllers\User;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Report;
use Exception;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function create(Request $req)
    {
        $user = auth()->guard('users')->user();
        $type = $req->type;
        $reported_item = $req->reported_item;
        $reason = $req->reason;

        try {
            Report::create([
                'user_type' => 'user',
                'user_id' => $user->id,
                'type' => $type,
                'reported_item' => $reported_item,
                'reason' => $reason
            ]);

            return ResponseData::success('گزارش شما با موفقیت دریافت شد');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در انجام عملیات');
        }
    }
}
