<?php

namespace App\Http\Controllers\User;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Protest;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class ProtestController extends Controller
{
    public function create(Request $req)
    {
        $type = $req->type;
        $extra = $req->extra;
        $description = $req->description;

        try {
            $avatar = null;
            if ($req->hasFile('attachment')) {
                $image = $req->file('attachment');
                $filename = time() . '_' . $image->getClientOriginalName();
                $image->move(public_path('uploades/documents/'), $filename);
                $avatar = URL::to("/").'/uploades/documents/' . $filename;
            }

            if($type == 'پیگیری سفارش'){
                $order= Order::where('id', $extra)->first();
                if(!$order){
                    return ResponseData::error('سفارشی با شناسه وارد شده یافت نشد');
                }
            }
            Protest::create([
                'user_type' => 'user',
                'user_id' => auth()->guard('users')->user()->id,
                'type' => $type,
                'extra' => $extra,
                'description' => $description,
                'attachment' => $avatar
            ]);

            return ResponseData::success('عملیات با موفقیت انجام شد');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در انجام عملیات');
        }
    }
}
