<?php

namespace App\Http\Controllers\User;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserResource;
use App\Models\DeletedProfile;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use URL;

class ProfileController extends Controller
{
    public function update(Request $req)
    {
        $user = auth()->guard('users')->user();
        $firstName = $req->first_name;
        $lastName = $req->last_name;
        $email = $req->email;
        $birth_date = $req->birth_date;
        $gender = $req->gender;

        try {
            $avatar = "";
            if ($req->hasFile('avatar')) {
                $image = $req->file('avatar');
                $filename = time() . '_' . $image->getClientOriginalName();
                $image->move(public_path('avatar'), $filename);
                $avatar = 'avatar/' . $filename;
            }
            $user->first_name = $firstName;
            $user->last_name = $lastName;
            $user->email = $email;
            $user->birth_date = $birth_date;
            $user->gender = $gender;
            if (strlen($avatar) > 0) {
                $user->avatar = $avatar;
            }
            $user->save();

            $userUpdated = User::where('id', $user->id)->first();
            return ResponseData::success('User Updated', new UserResource($userUpdated));
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ثبت تغییرات');
        }
    }

    public function deleteProfile(Request $req)
    {
        $user = auth()->guard('users')->user();

        DB::beginTransaction();
        try {
            DeletedProfile::create([
                'user_id' => $user->id,
                'mobile' => $user->mobile,
                'email' => $user->email
            ]);
            $user->mobile = 'deleted' . $user->id;
            $user->email = 'deleted' . $user->id;
            $user->save();

            DB::commit();
            return ResponseData::success('حساب کاربری با موفقیت حذف شد');
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error($ex->getMessage());
            return ResponseData::error('خطا در حذف حساب کاربری');
        }
    }
}
