<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Resources\Notification\NotificationResource;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index(){
        $user = auth()->guard('users')->user();
        $notifications = Notification::where('receiver_id', $user->id)
        ->where('receiver_type', 'user')
        ->orderBy('seen')->paginate(20);

        return NotificationResource::collection($notifications);
    }
}
