<?php

namespace App\Http\Controllers\User;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Requests\RegisterUserRequest;
use App\Http\Resources\User\UserResource;
use App\Models\AppVersion;
use App\Services\MobileTokenService\MobileTokenService;
use App\Models\User;
use App\Services\DeviceTokenService\DeviceTokenService;
use App\Services\SmsService\SmsService;
use Exception;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    public function requestCode(Request $req)
    {
        $mobile = $req->mobile;

        $code = MobileTokenService::generateToken($mobile);
        //Send SMS
        //SmsService::sendSms($mobile, "کد تایید کارآویز: " . $code . "\n \n \n aCqSDWF133f");
        return ResponseData::success("کد تایید با موفقیت برای شما ارسال شد");
    }

    public  function validateUser(Request $req)
    {
        $mobile = $req->mobile;
        $code = $req->code;
        $deviceToken = $req->fcm_token;
        if (MobileTokenService::verifyToken($mobile, $code)) {
            $user = User::where('mobile', $req->mobile)->first();
            if ($user) {
                if (!$token = auth()->guard('users')->login($user)) {
                    return ResponseData::error("اطلاعات ورود نادرست است", null, 403);
                }
                if ($deviceToken && strlen($deviceToken) > 0) {
                    DeviceTokenService::setToken($user->id, "user", $deviceToken);
                }
                return $this->respondWithToken($token);
            }
            return ResponseData::error("ایجاد حساب کاربری", null, 201);
        } else {
            return ResponseData::error("کد وارد شده نامعتبر است", null, 400);
        }
    }

    public function register(RegisterUserRequest $request)
    {
        $deviceToken = $request->fcm_token;
        try {
            $u = User::create([
                'mobile' => $request->mobile,
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'avatar' => $request->avatar,
                'email' => $request->email,
                'gender' => $request->gender,
                'referral_code' => $this->generateRandomString(),
                'birth_date' => $request->birth_date
            ]);
            if (!$token = auth()->guard('users')->login($u)) {
                return ResponseData::error("اطلاعات ورود نادرست است", null, 403);
            }
            if ($deviceToken && strlen($deviceToken) > 0) {
                DeviceTokenService::setToken($u->id, "user", $deviceToken);
            }
            return $this->respondWithToken($token);
        } catch (Exception $e) {
            return ResponseData::error($e->getMessage());
            return ResponseData::error('خطا در ایجاد حساب کاربری');
        }
    }

    public function setToken(Request $req)
    {
        $user = auth()->guard('users')->user();
        DeviceTokenService::setToken($user->id, "user", $req->fcm_token);
        return ResponseData::success('done');
    }

    public function logout(Request $req)
    {
        $user = auth()->guard('users')->user();
        DeviceTokenService::deactiveToken($user->id, "user", $req->fcm_token);
        return ResponseData::success('done');
    }

    protected function respondWithToken($token)
    {
        $data = [
            'access_token' => $token,
            'token_type' => 'bearer',
            'user' => new UserResource(auth()->guard('users')->user()),
            'expires_in' => auth()->guard('users')->factory()->getTTL() * 60
        ];
        return ResponseData::success('خوش آمدید', $data);
    }

    private function generateRandomString($length = 7)
    {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);

        $randomString = '';
        do {
            $randomString = '';
            for ($i = 0; $i < $length; $i++) {
                $randomString .= $characters[random_int(0, $charactersLength - 1)];
            }
            $check = User::where('referral_code', $randomString)->first();
        } while ($check);

        return $randomString;
    }

    public function checkVersion(Request $req)
    {
        $version = AppVersion::where('app', 'user')->where('active', 1)->where('version', $req->version)->count();
        return ResponseData::success('done', [
            'valid_version' => $version
        ]);
    }
}
