<?php

namespace App\Http\Controllers\User;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Address\AddressResource;
use App\Models\Address;
use Exception;
use Illuminate\Http\Request;

class AddressController extends Controller
{
    public function index()
    {
        $user = auth()->guard('users')->user();
        $addresses = Address::where('user_id', $user->id)->get();
        return AddressResource::collection($addresses);
    }

    public function create(Request $req)
    {
        $user = auth()->guard('users')->user();
        $address = $req->address;
        $phone = $req->phone;
        $lat = $req->lat;
        $lang = $req->lang;
        $title = $req->title;
        $plate = $req->plate;
        $unit = $req->unit;

        try {
            Address::create([
                'address' => $address,
                'phone' => $phone,
                'lat' => $lat,
                'lang' => $lang,
                'title' => $title,
                'plate' => $plate,
                'unit' => $unit,
                'user_id' => $user->id
            ]);

            $addresses = Address::where('user_id', $user->id)->get();
            return AddressResource::collection($addresses);
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت آدرس');
        }
    }

    public function update(Request $req)
    {
        $user = auth()->guard('users')->user();
        $id = $req->id;
        $address = $req->address;
        $phone = $req->phone;
        $lat = $req->lat;
        $lang = $req->lang;
        $title = $req->title;
        $plate = $req->plate;
        $unit = $req->unit;

        try {
            $a = Address::where('id', $id)->first();
            $a->address = $address;
            $a->phone = $phone;
            $a->lat = $lat;
            $a->lang = $lang;
            $a->title = $title;
            $a->plate = $plate;
            $a->unit = $unit;
            $a->save();

            $addresses = Address::where('user_id', $user->id)->get();
            return AddressResource::collection($addresses);
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ویرایش آدرس');
        }
    }

    public function delete(Request $req)
    {
        $user = auth()->guard('users')->user();
        Address::where('id', $req->id)->where('user_id', $user->id)->delete();
        return ResponseData::success('آدرس با موفقیت حذف شد');
    }
}
