<?php

namespace App\Http\Controllers;

use App\Helpers\ResponseData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;

class UploadController extends Controller
{
    public function document(Request $req)
    {
        $image = $req->file('files');
        $filename = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('uploades/documents'), $filename);
        $photo_path = URL::to('/') . '/uploades/documents/' . $filename;

        return response($photo_path);
    }

    public function avatar(Request $req)
    {
        $image = $req->file('files');
        $filename = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('uploades/avatars'), $filename);
        $photo_path = URL::to('/') . '/uploades/avatars/' . $filename;

        return response($photo_path);
    }
    public function video(Request $req)
    {
        $image = $req->file('files');
        $filename = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('uploades/videos'), $filename);
        $photo_path = URL::to('/') . '/uploades/videos/' . $filename;

        return response($photo_path);
    }

    public function blogEditorImages(Request $req)
    {
        $data = array();
        if ($req->hasfile('images')) {

            foreach ($req->file('images') as $image) {
                $filename = time() . '_' . $image->getClientOriginalName();
                $image->move(public_path('editor/blogs'), $filename);
                $photo_path = URL::to('/') . '/editor/blogs/' . $filename;

                array_push($data, $photo_path);
            }
        }
        return ResponseData::success("Done", $data);
    }
}
