<?php

namespace App\Http\Controllers\Home;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\CategoryWithServices\CategoryWithServicesResource;
use App\Http\Resources\HomeCategory\HomeCategoryResource;
use App\Http\Resources\Question\QuestionResource;
use App\Http\Resources\Service\ServiceResource;
use App\Http\Resources\ServiceWithQuestions\ServiceWithQuestionsResource;
use App\Models\Category;
use App\Models\Order;
use App\Models\Question;
use App\Models\Service;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ServicesController extends Controller
{
    public function Categories()
    {
        $categoris = Category::where('parent', 0)->where('active', 1)->where('deleted', 0)->orderBy('sort_order')->get();
        return CategoryResource::collection($categoris);
    }

    public function homeCategory()
    {
        $categoris = Category::where('parent', 0)->where('active', 1)->where('deleted', 0)->orderBy('sort_order')->get();
        return CategoryResource::collection($categoris);
    }

    public function ServicesWithCategory(Request $req)
    {
        $categoris = Category::where('parent', '!=', 0)->where('active', 1)->where('deleted', 0)->orderBy('parent')->orderBy('sort_order')->get();
        return CategoryWithServicesResource::collection($categoris);
    }

    public function CategoryDetails($id)
    {
        $category = Category::where('id', $id)->first();
        return HomeCategoryResource::make($category);
    }

    public function Services(Request $req)
    {
        $services = Service::where('category_id', $req->id)->where('active', "!=", 0)->select(["id", "title", "sub_title", "image","active","price_type","price"])->paginate(16);
        return ServiceResource::collection($services);
    }

    public function ServiceDetails(Request $req)
    {
        $service = Service::where('id', $req->id)->firstOrFail();
        return ResponseData::success('service details', ServiceResource::make($service));
    }

    public function ServiceDetailsWithQuestions(Request $req)
    {
        $service = Service::where('id', $req->id)->firstOrFail();
        return ResponseData::success('service details', ServiceWithQuestionsResource::make($service));
    }

    public function Search(Request $req)
    {
        $services = Service::where('title', 'like', '%' . $req->keyword . '%')->paginate(16);
        return ServiceResource::collection($services);
    }

    public function ServiceQuestions(Request $req)
    {
        $questions = Question::where('service_id', $req->id)->orderBy('sort_order')->get();
        return QuestionResource::collection($questions);
    }

    public function mostUsed(Request $req)
    {
        $date = Carbon::now()->subDays(10);
        $service_ids = DB::table('orders')
            ->where('status', '!=', 'canceled')
            ->where('created_at', '>=', $date)
            ->select('service_id', DB::raw('count(*) as total'))
            ->groupBy('service_id')
            ->orderByDesc('total')
            ->limit(8)->pluck('service_id')->toArray();

        if (count($service_ids) < 8) {
            $ids = Service::where('active', 1)->inRandomOrder()->limit(8 - count($service_ids))->pluck('id')->toArray();
            $service_ids = array_merge($service_ids, $ids);
        }
        $services = Service::whereIn('id', $service_ids)->get();
        return ResponseData::success('d', ServiceResource::collection($services));
    }
}
