<?php

namespace App\Http\Controllers\Home;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\CategoryWithLastrServices\CategoryWithLastrServicesResource;
use App\Models\Banner;
use App\Models\Category;
use App\Models\Service;
use App\Models\Slider;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function slider(Request $req)
    {
        $slider = Slider::orderByDesc('created_at')->get();
        return ResponseData::success('Slider', $slider);
    }

    public function banners(Request $req)
    {
        $service = Category::where('parent', '0')->where('deleted', '0')->where('active', '1')->orderBy('sort_order')->get();
        return CategoryWithLastrServicesResource::collection($service);
    }

    public function getBanner(Request $req)
    {
        $banner = Banner::where('title', $req->title)->first();
        return ResponseData::success('Banner', $banner);
    }
}
