<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserResource;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function index(Request $req)
    {
        $users = User::query();
        if ($req->query('search', '') != "") {
            $keyword = $req->query('search', "");
            $users->where(function ($q) use ($keyword) {
                $q->where(DB::raw('CONCAT(first_name," ",last_name)'), 'LIKE', '%' . $keyword . '%');
                $q->orWhere('mobile', 'LIKE', '%' . $keyword . '%');
            });
        }

        $data = $users->paginate(20);
        return UserResource::collection($data);
    }

    public function details($id)
    {
        $user = User::where('id', $id)->first();
        return ResponseData::success('Expert details', new UserResource($user));
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $first_name = $req->first_name;
        $last_name = $req->last_name;
        $gender = $req->gender;
        $email = $req->email;

        try {
            $user = User::where('id', $id)->first();
            $user->first_name = $first_name;
            $user->last_name = $last_name;
            $user->gender = $gender;
            $user->email = $email;

            $user->save();
            return ResponseData::success('تغییرات با موفقیت ثبت شد');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ویرایش متخصص');
        }
    }
}
