<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\Service;
use App\Models\ServiceTarrif;
use Exception;
use Illuminate\Http\Request;

class ServiceTarrifController extends Controller
{
    public function index(Request $req)
    {
        $id = $req->id;
        $service = Service::where('id', $id)->first();
        $tarrifs = ServiceTarrif::where('service_id', $id)->get();
        return ResponseData::success('tarrifs', ['tarrifs' => $tarrifs, 'service' => $service,]);
    }

    public function manageShowTarrif(Request $req){
        $id = $req->id;
        $show_tarrif = $req->show_tarrif;
        Service::where('id', $id)->update(['show_tarrif'=>$show_tarrif]);
    }

    public function create(Request $req)
    {
        $service = $req->service;
        $title = $req->title;
        $price = $req->price;
        $unit = $req->unit;

        try {
            ServiceTarrif::create([
                'service_id' => $service,
                'title' => $title,
                'price' => $price,
                'unit' => $unit,
            ]);
            return ResponseData::success('done');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ثبت تعرفه');
        }
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $title = $req->title;
        $price = $req->price;
        $unit = $req->unit;

        try {
            ServiceTarrif::where('id', $id)->update([
                'title' => $title,
                'price' => $price,
                'unit' => $unit,
            ]);
            return ResponseData::success('done');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ویرایش تعرفه');
        }
    }

    public function delete(Request $req)
    {
        ServiceTarrif::where('id', $req->id)->delete();
        return ResponseData::success('done');
    }
}
