<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Models\ServiceFeature;
use Exception;
use Illuminate\Http\Request;

class ServiceFeatureController extends Controller
{
    public function index(Request $req)
    {
        $features = ServiceFeature::where('service_id', $req->id)->orderByDesc('status')->get();

        return ResponseData::success('features', $features);
    }

    public function create(Request $req)
    {
        $service = $req->service;
        $title = $req->title;
        $status = $req->status;

        try {
            $feature = ServiceFeature::create([
                'service_id' => $service,
                'title' => $title,
                'status' => $status
            ]);

            return ResponseData::success('feature', $feature);
        } catch (Exception $ex) {
            return ResponseData::error($ex->getMessage());
            return ResponseData::error('خطا در ثبت ویژگی');
        }
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $title = $req->title;
        $status = $req->status;
        try {
            $feature = ServiceFeature::where('id', $id)->update([
                'title' => $title,
                'status' => $status
            ]);

            return ResponseData::success('feature', $feature);
        } catch (Exception $ex) {
            return ResponseData::error('خطا در ویرایش ویژگی');
        }
    }

    public function delete(Request $req)
    {
        ServiceFeature::where('id', $req->id)->delete();
        return ResponseData::success('Feature deleted');
    }
}
