<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\AdminService\AdminServiceResource;
use App\Models\Category;
use App\Models\Question;
use App\Models\Service;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ServiceController extends Controller
{
    public function getTotal(Request $req)
    {
        $count = Service::where('category_id', $req->category)->count();
        return ResponseData::success('count', $count);
    }
    public function index(Request $req)
    {
        $data = $this->getServices($req);

        return AdminServiceResource::collection($data);
    }

    public function details($id)
    {
        $service = Service::where('id', $id)->first();

        return ResponseData::success('', new AdminServiceResource($service));
    }

    public function create(Request $req)
    {
        $category = $req->category;
        $title = $req->title;
        $description = $req->description;
        $image = $req->image;
        $active = $req->active;
        $assign_policy = $req->assign_policy;
        $fee_percent = $req->fee_percent;
        $price_type = $req->price_type;
        $price = $req->price||0;
        $price_description = $req->price_description;
        $rule = $req->rule;
        $start_hour = $req->start_hour;
        $end_hour = $req->end_hour;
        $delay = $req->delay;
        $factor_type = $req->factor_type;

        DB::beginTransaction();
        try {
            $count = Service::count();
            $service = Service::create([
                'category_id' => $category,
                'title' => $title,
                'description' => $description,
                'image' => $image,
                'active' => $active,
                'fee_percent' => $fee_percent,
                'sort_order' => $count + 1,
                'assign_policy' => $assign_policy,
                'price_type' => $price_type,
                'price' => $price,
                'price_description' => $price_description,
                'start_hour' => $start_hour,
                'end_hour' => $end_hour,
                'delay' => $delay,
                'rule' => $rule,
                'factor_type' => $factor_type,
            ]);
            Question::create([
                'service_id' => $service->id,
                'type' => 1,
                'title' => 'چه زمانی به این سرویس نیاز دارید؟',
                'short_title' => 'تاریخ و زمان',
                'next_question' => null,
                'sort_order' => 1,
                'allow_multiple' => false,
            ]);
            Question::create([
                'service_id' => $service->id,
                'type' => 5,
                'title' => 'آدرس را انتخاب کنید:',
                'short_title' => 'آدرس',
                'next_question' => null,
                'sort_order' => 2,
                'allow_multiple' => false,
            ]);
            DB::commit();
            return ResponseData::success('سرویس با موفقیت ثبت شد');
        } catch (Exception $e) {
            DB::rollBack();
            return ResponseData::error($e->getMessage());
            return ResponseData::error('خطا در ثبت خدمت');
        }
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $category = $req->category;
        $title = $req->title;
        $description = $req->description;
        $image = $req->image;
        $active = $req->active;
        $assign_policy = $req->assign_policy;
        $fee_percent = $req->fee_percent;
        $price_type = $req->price_type;
        $price = $req->price;
        $price_description = $req->price_description;
        $rule = $req->rule;
        $start_hour = $req->start_hour;
        $end_hour = $req->end_hour;
        $delay = $req->delay;
        $factor_type = $req->factor_type;

        try {
            $service = Service::where('id', $id)->first();
            $service->category_id = $category;
            $service->title = $title;
            $service->description = $description;
            $service->image = $image;
            $service->active = $active;
            $service->fee_percent = $fee_percent;
            $service->assign_policy = $assign_policy;
            $service->price_type = $price_type;
            $service->price = $price;
            $service->price_description = $price_description;
            $service->rule = $rule;
            $service->start_hour = $start_hour;
            $service->end_hour = $end_hour;
            $service->delay = $delay;
            $service->factor_type = $factor_type;

            $service->save();
            return ResponseData::success('سرویس با موفقیت ثبت شد');
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت دسته بندی');
        }
    }

    public function changeStatus(Request $req)
    {
        $id = $req->id;
        $active = $req->active;

        try {
            Service::where('id', $id)->update(['active' => $active]);
            return ResponseData::success('Done');
        } catch (Exception $ex) {
            return ResponseData::error('خطا در انجام عملیات');
        }
    }

    public function changeOrder(Request $req)
    {
        $id = $req->id;
        $order = $req->order;
        $category = $req->category;

        DB::beginTransaction();
        try {
            $currentOrder = Service::where('id', $id)->first();
            if ($currentOrder->sort_order > $order) {
                Service::where('category_id', $category)->where('sort_order', '>=', $order)->where('sort_order', '<', $currentOrder->sort_order)->update(['sort_order' => DB::raw('sort_order+1')]);
            } else {
                Service::where('category_id', $category)->where('sort_order', '>', $currentOrder->sort_order)->where('sort_order', '<=', $order)->update(['sort_order' => DB::raw('sort_order-1')]);
            }
            Service::where('id', $id)->update(['sort_order' => $order]);
            DB::commit();

            $data = $this->getServices($req);
            return AdminServiceResource::collection($data);
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error('خطا در انجام عملیات');
        }
    }
    public function delete(Request $req)
    {
        $s = Service::where('id', $req->id)->first();
        Service::where('category_id', $s->category_id)->where('sort_order', '>', $s->sort_order)->update(['sort_order' => DB::raw('sort_order-1')]);
        Service::where('id', $req->id)->delete();
        return ResponseData::success('خدمت با موفقیت حذف شد');
    }

    private function getServices(Request $req)
    {
        $services = Service::query();
        if ($req->query('category', "all") != "all") {
            $categoryItems = Category::where('parent', $req->query('category'))->pluck('id')->toArray();
            $services->whereIn('category_id', $categoryItems);
        }
        if ($req->query('subCategory', "all") != "all") {
            $services->where('category_id', $req->query('subCategory', "all"));
        }
        if ($req->query('active', "") != "") {
            $active = $req->query('active', "");
            $services->where('active', $active);
        }
        if ($req->query('searchQuery', "") != "") {
            $keyword = $req->query('searchQuery', "");
            $services->where('title', 'LIKE', "%$keyword%");
        }

        if ($req->query('sort', 'created_at') == "sort_order") {
            $data =  $services->orderBy($req->query('sort', 'created_at'))->paginate($req->query("perPage", 20));
        } else {
            $data =  $services->orderByDesc($req->query('sort', 'created_at'))->paginate($req->query("perPage", 20));
        }

        return $data;
    }

    public function fixSorting()
    {
        $cats = Category::where('parent', '!=', 0)->get();
        foreach ($cats as $cat) {
            $data = Service::where('category_id', $cat->id)->get();
            for ($i = 1; $i <= count($data); $i++) {
                Service::where('id', $data[$i - 1]->id)->update(['sort_order' => $i]);
            }
        }
        return ResponseData::success('done');
    }

    public function addQuestions()
    {
        $services = Service::get();
        foreach ($services as $ser) {
            $dS = Question::where('service_id', $ser->id)->where('type', 1)->first();
            if (!$dS) {
                Question::create([
                    'service_id' => $ser->id,
                    'type' => 1,
                    'title' => 'چه زمانی به این سرویس نیاز دارید؟',
                    'short_title' => 'تاریخ و زمان',
                    'next_question' => null,
                    'sort_order' => 1,
                    'allow_multiple' => false,
                ]);
            }
            $dA = Question::where('service_id', $ser->id)->where('type', 5)->first();
            if (!$dA) {
                Question::create([
                    'service_id' => $ser->id,
                    'type' => 5,
                    'title' => 'آدرس را انتخاب کنید:',
                    'short_title' => 'آدرس',
                    'next_question' => null,
                    'sort_order' => 2,
                    'allow_multiple' => false,
                ]);
            }
        }
        return ResponseData::success('done');
    }
}
