<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\ResponseData;
use App\Http\Controllers\Controller;
use App\Http\Resources\Category\CategoryResource;
use App\Models\Category;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ServiceCategoryController extends Controller
{
    public function index()
    {
        $category = Category::where('deleted', 0)->where('parent', 0)->orderByDesc('active')->orderBy('sort_order')->get();
        return CategoryResource::collection($category);
    }

    public function subCategories(Request $req)
    {
        $category = Category::where('deleted', 0)->where('parent', $req->parent)->orderByDesc('active')->orderBy('sort_order')->get();
        return CategoryResource::collection($category);
    }

    public function details($id)
    {
        $category = Category::where('id', $id)->first();
        return ResponseData::success('', new CategoryResource($category));
    }

    public function create(Request $req)
    {
        $parent = $req->parent;
        $name = $req->name;
        $image = $req->image;
        $banner = $req->banner;

        try {
            $count = Category::where('parent', $parent)->count();
            $category = Category::create([
                'name' => $name,
                'parent' => $parent,
                'image' => $image,
                'banner' => $banner,
                'sort_order' => $count + 1
            ]);
            return ResponseData::success('دسته بندی با موفقیت ایجاد شد', new CategoryResource($category));
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت دسته بندی');
        }
    }

    public function update(Request $req)
    {
        $id = $req->id;
        $parent = $req->parent;
        $name = $req->name;
        $image = $req->image;
        $active = $req->active;
        $banner = $req->banner;

        try {
            $category = Category::where('id', $id)->first();
            $category->name = $name;
            $category->parent = $parent;
            $category->image = $image;
            $category->active = $active;
            $category->banner = $banner;

            $category->save();

            return ResponseData::success('دسته بندی با موفقیت ویرایش شد');
        } catch (Exception $e) {
            return ResponseData::error('خطا در ثبت دسته بندی');
        }
    }

    public function delete(Request $req)
    {
        $id = $req->id;
        $category = Category::where('id', $id)->first();
        $category->deleted = 1;
        $category->save();
        return ResponseData::success('دسته بندی با موفقیت حذف شد');
    }

    public function changeCategoryOrder(Request $req)
    {
        $id = $req->id;
        $order = $req->order;

        DB::beginTransaction();
        try {
            $currentOrder = Category::where('parent', 0)->where('id', $id)->first();
            if ($currentOrder->sort_order > $order) {
                Category::where('parent', 0)->where('sort_order', '>=', $order)->where('sort_order', '<', $currentOrder->sort_order)->update(['sort_order' => DB::raw('sort_order+1')]);
            } else {
                Category::where('parent', 0)->where('sort_order', '>', $currentOrder->sort_order)->where('sort_order', '<=', $order)->update(['sort_order' => DB::raw('sort_order-1')]);
            }
            Category::where('parent', 0)->where('id', $id)->update(['sort_order' => $order]);
            DB::commit();

            $category = Category::where('deleted', 0)->where('parent', 0)->orderByDesc('active')->orderBy('sort_order')->get();
            return CategoryResource::collection($category);
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error('خطا در انجام عملیات');
        }
    }

    public function changeSubCategoryOrder(Request $req)
    {
        $id = $req->id;
        $parent = $req->parent;
        $order = $req->order;

        DB::beginTransaction();
        try {
            $currentOrder = Category::where('parent', $parent)->where('id', $id)->first();
            if ($currentOrder->sort_order > $order) {
                Category::where('parent', $parent)->where('sort_order', '>=', $order)->where('sort_order', '<', $currentOrder->sort_order)->update(['sort_order' => DB::raw('sort_order+1')]);
            } else {
                Category::where('parent', $parent)->where('sort_order', '>', $currentOrder->sort_order)->where('sort_order', '<=', $order)->update(['sort_order' => DB::raw('sort_order-1')]);
            }
            Category::where('parent', $parent)->where('id', $id)->update(['sort_order' => $order]);
            DB::commit();

            $category = Category::where('deleted', 0)->where('parent', $parent)->orderByDesc('active')->orderBy('sort_order')->get();
            return CategoryResource::collection($category);
        } catch (Exception $ex) {
            DB::rollBack();
            return ResponseData::error('خطا در انجام عملیات');
        }
    }

    public function fixSorting()
    {
        $categories = Category::select('parent')->distinct()->get();
        foreach ($categories as $cat) {
            $data = Category::where('parent', $cat->parent)->get();
            for ($i = 1; $i <= count($data); $i++) {
                Category::where('id', $data[$i - 1]->id)->update(['sort_order' => $i]);
            }
        }
        return ResponseData::success('done');
    }
}
